/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoSource;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpContext;
import com.quantumdata.ftp.FtpControlSocket;
import com.quantumdata.ftp.FtpInterpret;
import java.io.IOException;

public final class Ftp
implements CoSource {
    public static final int PORT = 21;
    private FtpContext m_context = new FtpContext();
    private FtpControlSocket m_control = new FtpControlSocket(this.m_context);

    public boolean connect(FtpConnect ftpConnect) throws IOException {
        if (this.connect(ftpConnect.getHostName(), ftpConnect.getPortNum())) {
            if (this.login(ftpConnect.getUserName(), ftpConnect.getPassWord())) {
                String string = ftpConnect.getPathName();
                if (string.length() > 0) {
                    this.cd(string);
                }
            } else {
                this.disconnect();
            }
        }
        return this.isConnected();
    }

    public boolean connect(String string, int n) throws IOException {
        if (!this.isConnected() && string != null && this.m_control.connect(string, n)) {
            if (!this.m_control.completeCommand(FtpInterpret.getReplies("login-done"))) {
                this.printlog("< Can't obtain welcome message from host! >");
                this.m_control.disconnect();
            } else {
                return true;
            }
        }
        return false;
    }

    public void disconnect() {
        this.m_control.disconnect();
    }

    public void abort() {
        this.disconnect();
    }

    public boolean login(String string, String string2) throws IOException {
        if (this.m_control.executeCommand("USER " + string) && this.m_control.executeCommand("PASS " + string2)) {
            this.syst();
            return true;
        }
        this.printlog("< Can't login to host. >");
        return false;
    }

    public String host() throws IOException {
        if (this.isConnected()) {
            return this.m_control.getServer();
        }
        throw new IOException("Ctrl: No Connection!");
    }

    public boolean command(String string) {
        return this.m_control.manualCommand(string);
    }

    public boolean rmdir(String string) {
        return this.m_control.executeCommand("RMD " + string);
    }

    public boolean mkdir(String string) {
        return this.m_control.executeCommand("MKD " + string);
    }

    public String pwd() throws IOException {
        if (this.isConnected()) {
            String string = null;
            this.m_control.executeCommand("PWD");
            String string2 = this.m_control.replyOfCommand();
            try {
                string = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new IOException("Ctrl: PWD, Invalid Format!");
            }
            return string;
        }
        throw new IOException("Ctrl: PWD, No Connection!");
    }

    public String syst() throws IOException {
        if (this.isConnected()) {
            this.m_control.executeCommand("SYST");
            String string = this.m_control.replyOfCommand();
            this.getContext().setServerSystemMode(1);
            if (string != null && string.toUpperCase().indexOf("WINDOWS") >= 0) {
                this.getContext().setServerSystemMode(2);
                this.printlog("< File: Setting 'WIN' Server Mode >");
            }
            return string;
        }
        throw new IOException("Ctrl: PWD, No Connection!");
    }

    public boolean cd(String string) {
        return this.m_control.executeCommand("CWD " + string);
    }

    public boolean cdup() {
        return this.m_control.executeCommand("CDUP");
    }

    public boolean rm(String string) {
        return this.m_control.executeCommand("DELE " + string);
    }

    public boolean mv(String string, String string2) {
        if (this.m_control.executeCommand("RNFR " + string)) {
            return this.m_control.executeCommand("RNTO " + string2);
        }
        return false;
    }

    public boolean chmod(String string, String string2) {
        return this.m_control.executeCommand("SITE CHMOD " + string2 + " " + string);
    }

    public boolean isConnected() {
        return this.m_control.isConnected();
    }

    public FtpContext getContext() {
        return this.m_context;
    }

    public FtpControlSocket getControl() {
        return this.m_control;
    }

    void printlog(String string) {
        this.m_context.printlog(string);
    }

    void printerr(Exception exception) {
        this.m_context.printerr(exception);
    }
}

